"""
Example 3

- calculate brilliance curves of 4 different BLs for comparison
"""

if __name__ == "__main__":
    import spectra 
    spectra.Start()

spectra.Open("sample.json") 

ublnames = ["X-ray-BL", "SX-BL"]
bmblnames = ["BM-BL", "Wiggler-BL"]

# brilliance curve for undulator beamlines
for ubl in ublnames:
    spectra.SelectBL(ubl)
    spectra.SelectCalculation("far", "Kvalue", "simpcalc", "allharm")
    spectra.StartCalculation(folder="./output", prefix=ubl, serial=-1)

# spectrum for BM/Wiggler beamlines
for bmbl in bmblnames:
    spectra.SelectBL(bmbl)
    spectra.SelectCalculation("far", "energy", "simpcalc")
    spectra.StartCalculation(prefix=bmbl, serial=-1)

# compare the brilliance
spectra.PostProcess.SelectData(ublnames[0])
spectra.PostProcess.Plot("GA. Brilliance")
spectra.PostProcess.ComparativePlot(*ublnames, *bmblnames)
spectra.PostProcess.PlotScale(x="log", y="log")

if __name__ == "__main__":
    input("Completed. Press enter to exit. ")
    spectra.Exit()
