"""
Example 1

- calculate spectra of undulator radiation with three different observation positions
- compare the three in the post-processor and export an ASCII file
"""

if __name__ == "__main__":
    import spectra 

# start with default settings
# Mode = interactive, Browser = Chrome, Source Files = remote
    spectra.Start() 

# open "sample.json" in the current directory
spectra.Open("sample.json") 

# select calculation: "Far Field & Ideal Condition::Energy Dependence::Angular Flux Density"
spectra.SelectCalculation("far", "energy", "fdensa")

# start calculation with an output file of "./output/sample1-1.json"
spectra.StartCalculation(folder="./output", prefix="sample1", serial=1)

# check the result; plot the spectrum of angular flux density
spectra.PostProcess.Plot("Flux Density")

# change the paramter, vertical position shifted to y=1mm
spectra.Set("config", "xyfix", [0, 1])

# start calculation with an output file of "sample1-2.json"
# same folder and prefix
# serial number automatically incremented
spectra.StartCalculation()

# horizontal position shifted to x=1mm; output file "sample1-3.json"
spectra.Set("config", "xyfix", [1, 0])
spectra.StartCalculation()

# check the result; compare with the former result
spectra.PostProcess.SelectData("sample1-1")
spectra.PostProcess.Plot("Flux Density")
spectra.PostProcess.ComparativePlot("sample1-2", "sample1-3")
spectra.PostProcess.DuplicatePlot()

# export the comparative plot as an ASCII file
spectra.PostProcess.Export("./output/comparative.txt")

# expand the fundamental radiation
spectra.PostProcess.PlotRange(x=[5000,6500])

if __name__ == "__main__":

# wait for the user's response
    input("Completed. Press enter to exit. ")

# exit
    spectra.Exit()

