"""
Example 4

- examine how to improve the numerical accuracy
"""

if __name__ == "__main__":
    import spectra
    spectra.Start() 

spectra.Open("sample.json") 
spectra.SelectBL("X-ray-BL")
spectra.SelectCalculation("near", "energy", "pflux", "slitrect")
spectra.FitWindow()
spectra.Set("src", "e1st", 10000)
spectra.Set("config", "erange", [9000, 11000])

# expand the aperture to check the accuracy of spatial integration
spectra.Set("config", "slitapt", [2, 2])
spectra.StartCalculation(folder="./output", prefix="sample4", serial=1)

# try to improve the numerical accuracy
# "accinobs" = Integration Step in Transverse Grid (default = 1)
spectra.Set("config", "accuracy", "Custom")
spectra.SetAccuracy("accinobs", 2)
spectra.StartCalculation() # needs a bit more CPU time

# compare the result
spectra.PostProcess.Plot("Flux")
spectra.PostProcess.SelectData("sample4-1")
spectra.PostProcess.ComparativePlot("sample4-2", "sample4-3")

if __name__ == "__main__":
    input("Completed. Press enter to exit. ")
    spectra.Exit()
