"""
Example 6

- scan a parameter and visualize the result as an animation in the post-processor
- variation of the spatial profile as the change of the photon energy
"""

if __name__ == "__main__":
    import spectra
    spectra.Start()

spectra.Open("sample.json") 
spectra.SelectBL("X-ray-BL")

# flux spatial profile
spectra.SelectCalculation("far", "spatial", "fdensa", "meshxy")

# define the photon energy by the normalized value (by e1st)
spectra.Set("config", "normenergy", True) 

# expand the observation range
spectra.Set("config", "xrange", [-1.5, 1.5]) 
spectra.Set("config", "yrange", [-1.5, 1.5]) 

# scan the photon energy to observe
spectra.Scan("config", "nefix", 0.9, 1.05, 21, folder="./output", prefix="sample6", serial=-1)

# visualize the results
spectra.PostProcess.SurfacePlot()
spectra.PostProcess.NormalizePlot(True)
spectra.PostProcess.StartAnimation()

if __name__ == "__main__":
    input("Completed. Press enter to exit. ")
    spectra.Exit()
