"""
Example 1

- SASE FEL of 10-keV radiation and plot the gain curve
- visualize the growth of the radiation profile
"""

if __name__ == "__main__":
    import simplex 

# start with default settings
# Mode = interactive, Browser = Chrome, Source Files = remote
    simplex.Start() 

# open "sample.json" in the current directory
simplex.Open("sample_sase.json")

# export radiation profile data (longer time needed)
simplex.Set("datadump", "temporal", True)
simplex.Set("datadump", "spectral", True)
simplex.Set("datadump", "spatial", True)
simplex.Set("datadump", "angular", True)

# start simulation with an output file of "./output/sample1.json"
simplex.StartSimulation(folder="./output", prefix="sample1", serial=-1)

# plot the gain curve (pulse energy vs. undulator length)
simplex.PostProcess.PlotGainCurve("Pulse Energy")

# switch to semi-log scale
simplex.PostProcess.PlotScale(y="log")

# plot in a new window
simplex.PostProcess.DuplicatePlot("Gain Curve: Pulse Energy vs Undulator Length")

# visualize the growth of the temporal and spectral profiles of radiation
simplex.PostProcess.TemporalProfile()
simplex.PostProcess.MultiPlot("Photon Flux")
simplex.PostProcess.MultiPlotCols(2)
simplex.PostProcess.SetSlide(-1)
simplex.PostProcess.DuplicatePlot("Growth of Temporal and Spectral Profiles")

# visualize the growth of the spatial and angular profiles of radiation
simplex.PostProcess.SpatialProfile()
simplex.PostProcess.MultiPlot("Angular Energy Density")                                                                                                                                                                                                                                                                                                                                 
simplex.PostProcess.SetSlide(-1)
simplex.PostProcess.DuplicatePlot("Growth of Spatial and Angular Profiles")

if __name__ == "__main__":
# wait for the user's response
    input("Completed. Press enter to exit. ")

# exit
    simplex.Exit()

