"""
Example 3

- SASE FEL of 10-keV radiation with three different combinations of electron energies and undulator K values
- compare the three results in the post-processor
"""

if __name__ == "__main__":
    import simplex 

# start with default settings
# Mode = interactive, Browser = Chrome, Source Files = remote
    simplex.Start() 

# open "sample.json" in the current directory
simplex.Open("sample_sase.json") 

EGeV = [6, 8, 10]

for E in EGeV:
    simplex.Set("ebeam", "eenergy", E) # change the electron energy
    simplex.Set("felprm", "e1st", 10000) # set the photon energy; K value is automatically set
    print(f"K@{E}GeV = {simplex.Get("undulator", "K"):.3f}")
    simplex.PreProcess.OptimizeLattice([10,10]) # adjust the beta-matching condition
    simplex.StartSimulation(folder="./output", prefix="sample3", serial=E)

# plot the gain curve (pulse energy vs. undulator length)
simplex.PostProcess.SelectData("sample3-6")
simplex.PostProcess.PlotGainCurve("Pulse Energy")
simplex.PostProcess.ComparativePlot("sample3-8", "sample3-10")
simplex.PostProcess.PlotScale(y="log")

if __name__ == "__main__":
    input("Completed. Press enter to exit. ")
    simplex.Exit()

