"""
Example 4

- shot-to-shot flucuation of SASE FEL simulated by varying the seed number for the random number
- compare the gain curve and spectral/temporal profiles
"""

if __name__ == "__main__":
    import simplex 

# start with default settings
# Mode = interactive, Browser = Chrome, Source Files = remote
    simplex.Start() 

# open "sample.json" in the current directory
simplex.Open("sample_sase.json")

# export the temporal and spectral proiles
simplex.Set("datadump", "temporal", True)

# number of shots
Nshots = 5

# scan the random number seed to simulate the shot-to-shot fluctuation
simplex.Scan("condition", "randseed", 1, Nshots, interval=1, folder="./output", prefix="sample4", iniSN=1)

# data names 
datanames = []
for n in range(Nshots):
    datanames.append("sample4"+"_"+str(n+1))

simplex.PostProcess.SelectData("sample4_1")

# gain curves
simplex.PostProcess.PlotGainCurve("Pulse Energy")
simplex.PostProcess.ComparativePlot(*datanames)
simplex.PostProcess.PlotScale(y="log")
simplex.PostProcess.DuplicatePlot("Shot-to-shot fluctuation of the gain curve")

# temporal profiles
simplex.PostProcess.TemporalProfile()
simplex.PostProcess.ComparativePlot(*datanames)
simplex.PostProcess.SetSlide(-1)
simplex.PostProcess.DuplicatePlot("Shot-to-shot fluctuation of the temporal profile")

if __name__ == "__main__":
# wait for the user's response
    input("Completed. Press enter to exit. ")

# exit
    simplex.Exit()
