"""
Example 7

- double-pulse SASE FEL by inserting a chicane to tune the delay in between
- visualize the growth of temporal profile
"""

if __name__ == "__main__":
    import simplex 

# start with default settings
# Mode = interactive, Browser = Chrome, Source Files = remote
    simplex.Start() 

# open "sample.json" in the current directory
simplex.Open("sample_sase.json") 

# setup chicane parameters
simplex.Set("chicane", "chicaneon", True)
simplex.Set("chicane", "delay", 10)
simplex.Set("chicane", "chpos", 5)

# expand the temporal window
simplex.Set("condition", "simrange", [-1e-6, 5e-6])
simplex.StartSimulation(folder="./output", prefix="sample7", serial=1)

# rearrange the macroparticle distribution to be consistent with the extinction of microbunching 
simplex.Set("chicane", "rearrange", True)
simplex.StartSimulation(folder="./output", prefix="sample7", serial=2)

# compare the two schemes
simplex.PostProcess.SelectData("sample7-1")
simplex.PostProcess.TemporalProfile()
simplex.PostProcess.ComparativePlot("sample7-2")
simplex.PostProcess.SetSlide(-1)

if __name__ == "__main__":
    input("Completed. Press enter to exit. ")
    simplex.Exit()
