"""
Example 6

- double-color SASE FEL by applying different K values in the first and second sections
- visualize the variation of spectral profile
"""

if __name__ == "__main__":
    import simplex 

# start with default settings
# Mode = interactive, Browser = Chrome, Source Files = remote
    simplex.Start() 

# open "sample.json" in the current directory
simplex.Open("sample_sase.json") 

simplex.Set("undulator", "taper", "Custom")
simplex.Set("datadump", "spectral", True)

taper = []
for n in range(12):
    taper.append(["0.02" if n >= 5 else "-0.02", "0"])
    # first 5 segments with lower K, last 7 segments with higher K
simplex.Set("undulator", "tapercustom", taper)

# start simulation with an output file of "./output/sample6.json"
simplex.StartSimulation(folder="./output", prefix="sample6", serial=-1)

simplex.PostProcess.SpectralProfile()
simplex.PostProcess.StartAnimation()

if __name__ == "__main__":
    input("Completed. Press enter to exit. ")
    simplex.Exit()
